/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.gui;

import codechicken.lib.vec.Rectangle4i;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import morph.avaritia.client.gui.Point;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DrawableElement {
    private final Screen parent;
    private final ResourceLocation spriteLocation;
    private final Rectangle4i sprite;
    private final Point location;
    private final DoubleSupplier animSupplier;
    private final AnimationDirection animDirection;
    private final BooleanSupplier renderPredicate;
    @Nullable
    private final Supplier<Component> tooltipSupplier;

    public DrawableElement(Screen parent, ResourceLocation spriteLocation, Rectangle4i sprite, Point location, DoubleSupplier animSupplier, AnimationDirection animDirection, BooleanSupplier renderPredicate, @Nullable Supplier<Component> tooltipSupplier) {
        this.parent = parent;
        this.spriteLocation = spriteLocation;
        this.sprite = sprite;
        this.location = location;
        this.animSupplier = animSupplier;
        this.animDirection = animDirection;
        this.renderPredicate = renderPredicate;
        this.tooltipSupplier = tooltipSupplier;
    }

    public Rectangle4i getBounds() {
        return new Rectangle4i(this.location.x, this.location.y, this.sprite.w, this.sprite.h);
    }

    public void drawTooltip(PoseStack pStack, int mouseX, int mouseY) {
        if (this.tooltipSupplier != null) {
            Component comp = this.tooltipSupplier.get();
            this.parent.m_96597_(pStack, List.of(comp), mouseX, mouseY);
        }
    }

    public void draw(PoseStack pStack) {
        if (!this.renderPredicate.getAsBoolean()) {
            return;
        }
        int x = this.location.x;
        int y = this.location.y;
        Rectangle4i curr = new Rectangle4i();
        switch (this.animDirection) {
            case STATIC: {
                curr.set(this.sprite.x, this.sprite.y, this.sprite.w, this.sprite.h);
                break;
            }
            case TOP_DOWN: {
                double progress = this.animSupplier.getAsDouble();
                curr.set(this.sprite.x, this.sprite.y, this.sprite.w, (int)((double)this.sprite.h * progress));
                break;
            }
            case BOTTOM_UP: {
                double progress = this.animSupplier.getAsDouble();
                int s = (int)((double)this.sprite.h * progress);
                y += this.sprite.h - s;
                curr.set(this.sprite.x, this.sprite.y + (this.sprite.h - s), this.sprite.w, s);
                break;
            }
            case LEFT_RIGHT: {
                double progress = this.animSupplier.getAsDouble();
                curr.set(this.sprite.x, this.sprite.y, (int)((double)this.sprite.w * progress), this.sprite.h);
                break;
            }
            case RIGHT_LEFT: {
                double progress = this.animSupplier.getAsDouble();
                int s = (int)((double)this.sprite.w * progress);
                x += this.sprite.w - s;
                curr.set(this.sprite.x + (this.sprite.w - s), this.sprite.y, s, this.sprite.h);
            }
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.spriteLocation);
        this.parent.m_93228_(pStack, x, y, curr.x, curr.y, curr.w, curr.h);
    }

    public static enum AnimationDirection {
        STATIC,
        TOP_DOWN,
        BOTTOM_UP,
        LEFT_RIGHT,
        RIGHT_LEFT;

    }
}

